$(function () {
  chkScreenSize();
  pageScroll();
});

$(window).on('load', function () {

});

$(window).on('resize', function () {
  chkScreenSize();
});

$(window).on('scroll', function () {
  
});

/* ----------------------------------------------------------
 chkScreenSize
---------------------------------------------------------- */
var MQ = "PC";
var oldMQ = MQ;
var chkScreenSize = function () {
  var mWidth = $("body").css("min-width");
  switch (mWidth) {
    case "2px":
      MQ = "TB";
      break;
    case "1px":
      MQ = "SP";
      break;
    default:
      MQ = "PC";
  }
  // trigger custom event when breakpoint change
  if (oldMQ !== MQ) {
    oldMQ = MQ;
    $(window).trigger("breakpointChange");
  }
}

/* ----------------------------------------------------------
 pageScroll
---------------------------------------------------------- */
var pageScroll = function () {
  $('.js-scroll , .qalist a').on('click', function () {
    var speed = 400;
    var href = $(this).attr("href");
    var target = $(href == "#" || href == "" ? 'html' : href);

    if(MQ == 'PC') {
      var headerH = $('.header').height() + $('.list-header').height();
    } else {
      if($('#gakubu').length != 0) {
        var headerH = $('.header').height() + $('.box-heading-gakubu').height();
      } else {
        var headerH = $('.header').height();
      }
    }

    var position = target.offset().top - headerH - 40;
    if (href == '#') {
      $('body,html').animate({ scrollTop: 0 }, speed, 'swing');
    } else {
      $('body,html').animate({ scrollTop: position }, speed, 'swing');
    }

    return false;
  });
}

// if accessed from outer page link(url with #)
$(window).on('load',function(){
  var urlhash = location.hash;
  if(urlhash && urlhash !== '#btn'){
    $('body,html').stop().scrollTop(0);
    setTimeout(function(){
        var speed = 400;
        if(MQ == 'PC') {
          var headerH = $('.header').height() + $('.list-header').height();
        } else {
          if($('#gakubu').length != 0) {
            var headerH = $('.header').height() + $('.box-heading-gakubu').height();
          } else {
            var headerH = $('.header').height();
          }
        }

        var target = $(urlhash);
        var margin = 40;

        var position = target.offset().top - Number(headerH) -margin;
        // var position = target.offset().top;

        $('body,html').stop().animate({scrollTop:position}, speed, 'swing');
    },100);
  }
})


/* ----------------------------------------------------------
 accordion footer SP
---------------------------------------------------------- */
$(window).on('resize', function () {
  if((MQ == 'TB') || (MQ == 'PC')) {
    $('.footer-top .footer-link-wrap .title').removeClass('is-active');
    $('.footer-top .footer-link').removeAttr('style');
  }
});
$(function () {
  $('.footer-link-wrap .title .btn-accd').on('click', function () {
    if(MQ == 'SP') {
      if (!$(this).parents('.title').hasClass('is-active')) {
        $(this).parents('.title').addClass('is-active');
        $(this).parents('.title').next().stop().slideDown();
      } else {
        $(this).parents('.title').removeClass('is-active');
        $(this).parents('.title').next().stop().slideUp();
      }
    }
  });
});


/* ----------------------------------------------------------
 footer sitemap PC TB
---------------------------------------------------------- */
$(window).on('load resize', function () {
  if((MQ == 'TB') || (MQ == 'PC')) {
    $('.footer-link-accd').prev().css('display','none');
    $('.footer-link-accd').removeClass('is-active');
    } else {
    $('.footer-link-accd').prev().removeAttr('style');
  }
});
$(function () {
    $('.footer-link-accd').on('click', function () {
        if((MQ == 'TB') || (MQ == 'PC')) {
            $(this).toggleClass("is-active");
            $(this).prev().slideToggle();   
        }
    });
});

/* ----------------------------------------------------------
 nav-global
---------------------------------------------------------- */
// screen lock
var lockTop = 0;
var screenLock = function() {
  lockTop = $(window).scrollTop();
  $("html").addClass("is-screen-locked").css({
    top: -lockTop
  });
};

// screen unlock
var screenUnlock = function() {
  $("html").removeClass("is-screen-locked").removeAttr("style");
  $(window).scrollTop(lockTop);
};

/* nav-global Menu open close */
$(window).on('resize', function () {
  if(MQ == 'PC') {
    $('.header-menu').removeClass('is-active');
    $('.nav-global').removeAttr('style');
    $('html').removeClass('is-screen-locked').removeAttr('style');
    $('.header-menu .text:contains("CLOSE")').text("MENU");
  }
});

$(function(){
  $('.header-menu').on('click', function (){
    if((MQ == 'TB') || (MQ == 'SP')) {
      if (!$(this).hasClass('is-active')) {
        $(this).addClass('is-active');
        $('.nav-global').stop().slideDown();
        screenLock();
        $('.header-menu .text:contains("MENU")').text("CLOSE");

      } else {
        $(this).removeClass('is-active');
        $('.nav-global').stop().slideUp();
        screenUnlock();
        $('.header-menu .text:contains("CLOSE")').text("MENU");
      }
    }
  });
});

/* nav-global PC */
$(window).on('resize', function () {
  if((MQ == 'TB') || (MQ == 'SP')) {
    $('.nav-global .list-nav li').children('ul').removeClass('is-active');
  }
});
$(function () {
  $('.nav-global .list-nav li').each(function(){
    $(this).on('mouseover', function() {
      if(MQ == 'PC') {
        $(this).children('ul').addClass('is-active');
      }
    })
    .on( "mouseleave", function() {
      if(MQ == 'PC') {
        $(this).children('ul').removeClass('is-active');
      }
    });
  });
});

/* nav-global TB/SP */
$(window).on('resize', function () {
  if(MQ == 'PC') {
    $('.nav-global .list-nav > li ul').removeAttr('style');
    $(document).find('.nav-global .list-nav > li .btn-accd').removeClass('is-active').removeAttr('style');
  }
});

$(function () {
  $(document).on('click', '.nav-global .list-nav > li .btn-accd', function () {
    if((MQ == 'TB') || (MQ == 'SP')) {
      if (!$(this).hasClass('is-active')) {
        $(this).children('li').find('.btn-accd').addClass('is-active');
        $(this).addClass('is-active');
        $(this).prev().stop().slideDown();
      } else {
        $(this).removeClass('is-active');
        $(this).prev().stop().slideUp();
      }
    }
  })
});

/* add button accd */
$(function () {
  $(".nav-global .list-nav li").each(function() {
    if($(this).find("ul").length != 0){
      $(this).addClass('has-accd').append('<span class="btn-accd"></span>');
    }
  });
});

/* ----------------------------------------------------------
 footer-list PC tab SP accd
---------------------------------------------------------- */
/* PC tab */
$(window).on('breakpointChange', function(){
  if(MQ != 'SP') {
    if(!$('.footer-list .list-targets-pc').hasClass('is-pc')) {
      $('.footer-list .list-targets-pc').addClass('is-pc');
      $(".footer-list .list-targets-pc .item:first-child .link").trigger("click");
    }
  } else {
    $('.footer-list .list-targets-pc').removeClass('is-pc');
    $('.footer-list .box-targets').removeAttr('style');
    $('.footer-list .list-targets-pc .link').removeClass("is-active");
  }
});

$(function () {
  $(".footer-list .list-targets-pc .link").on('click', function (){
    if((MQ == 'PC') || (MQ == 'TB')) {
      if(!$(this).hasClass("is-active")) {
        var target = $(this).attr("href");
        $(".footer-list .list-targets-pc .link").removeClass("is-active");
        $(".footer-list .box-targets").hide();

        $(this).addClass("is-active");
        $(target).fadeIn();
      }
    }
    return false;
  });
  $(".footer-list .list-targets-pc .item:first-child .link").trigger("click");
});

/* SP accd */
$(window).on('breakpointChange', function(){
  if((MQ == 'PC') || (MQ == 'TB')) {
    $('.footer-list .ttl-targets-sp').removeClass('is-active');
  }
});

$(function () {
  $(".footer-list .ttl-targets-sp").on('click', function (){
    if(MQ == 'SP') {
      if (!$(this).hasClass('is-active')) {
        $(this).addClass('is-active');
        $(this).next().stop().slideDown();
      } else {
        $(this).removeClass('is-active');
        $(this).next().stop().slideUp();
      }
    }
  })
});


/* ----------------------------------------------------------
 matchHeight
---------------------------------------------------------- */
$(window).on('breakpointChange', function(){
  if((MQ == 'PC') || (MQ == 'TB')) {
    $('.list-cmn-campus .box-detail').matchHeight();
  } else {
    $('.list-cmn-campus .link > div').matchHeight({
      byRow: false
    });
  }
});
$(function() {
  $('.list-cmn-articles .box-detail .text').matchHeight();
  $('.list-feature-article .box-detail .text').matchHeight();
  $('.list-cmn-pickup .link > div').matchHeight();
  $('.list-cmn-card .item .box-detail').matchHeight();
  $('.list-research-card .item .box-detail').matchHeight();
  $('.list-cmn-border .item .box-detail').matchHeight();
  $('.list-cmn-group .item .link').matchHeight();

  if((MQ == 'PC') || (MQ == 'TB')) {
    $('.list-cmn-campus .box-detail').matchHeight();
  } else {
    $('.list-cmn-campus .link > div').matchHeight({
      byRow: false
    });
  }
});

/* ----------------------------------------------------------
 accordion information
---------------------------------------------------------- */
$(function(){
	$('.box-cmn-tab-wrap .box-title a.txt-accd').click(function(){

      if (!$(this).parents('.box-title').hasClass('is-active')) {
        $(this).parents('.box-title').addClass('is-active');
        $(this).parents('.box-title').next().stop().slideDown();
      } else {
        $(this).parents('.box-title').removeClass('is-active');
        $(this).parents('.box-title').next().stop().slideUp();
      }

	});
});

/* ----------------------------------------------------------
 tab information
---------------------------------------------------------- */

$(function () {
  $(".box-cmn-tab .list-tab .link").on('click', function (){
    if(!$(this).hasClass("is-active")) {
      var target = $(this).attr("href");
      $(".box-cmn-tab .list-tab .link").removeClass("is-active");
      $(".box-cmn-tab .box-tab").hide();

      $(this).addClass("is-active");
      $(target).fadeIn();
    }
    return false;
  });
  $(".box-cmn-tab .list-tab .item:first-child .link").trigger("click");
});

/* ----------------------------------------------------------
 accordion teacher
---------------------------------------------------------- */
$(function(){
	$('.list-accordion-teacher .box-accordion-head').click(function(){

      if (!$(this).hasClass('is-opened')) {
        $(this).addClass('is-opened');
        $(this).next().stop().slideDown();
      } else {
        $(this).removeClass('is-opened');
        $(this).next().stop().slideUp();
      }

	});
});

/* ----------------------------------------------------------
 table-scroll-wrap
---------------------------------------------------------- */
$(function(){
	$(' .editor table ').addClass(' table-scroll ');
	$(' .editor table ').wrap(' <div class="table-scroll-wrap"></div> ');
});

// for past article
$(function(){
  $('#MAIN-CONTENT-AREA').find('table').addClass(' table-scroll ');
  $('#MAIN-CONTENT-AREA').find('table').wrap(' <div class="table-scroll-wrap"></div> ');
})

$(function(){
  $(' .editor table ').css('width', '');
  $(' .editor table ').removeAttr('border cellpadding cellspacing');
});

/* ----------------------------------------------------------
 teachers selectedByKana
---------------------------------------------------------- */
function selectByKana(){
    var link = $('[name=kana] option:selected').data('url');
    if(link){
       location.href =  location.origin + link;
    }
  
}

/* ----------------------------------------------------------
 header-link-translation
---------------------------------------------------------- */
$(function () {
  $('.header-link .link.icon-lang').on('click', function () {
    $(this).next().children().slideToggle();
  });
});
$(function () {
  $('.wrap_langmenu .btn-lang-close').on('click', function () {
    $(this).parent().slideToggle();
  });
});